<?php

/**
 * @version		1.1.0
 * @package		Joomla
 * @subpackage	EShop
 * @author  	Carlhenrygloba
 * @copyright	Copyright (C) 2012 Carlhenrygloba
 * @license		Carlhenrygloba
 */
// no direct access
defined('_JEXEC') or die();

class os_ada extends os_payment
{

	/**
	 * Constructor functions, init some parameter
	 *
	 * @param object $config        	
	 */
	public function __construct($params)
	{
		$config = array(
            'type' => 0,
            'show_card_type' => false,
            'show_card_holder_name' => false
        );
		parent::__construct($params, $config);
		$this->api_key = $params->get('api_key');
		$this->url = $params->get('url');
		$this->sandbox = $params->get('sandbox');
		$this->expiration_time = $params->get('expiration_time');
		$this->setData('business', $params->get('paypal_id'));
		$this->setData('rm', 2);
		$this->setData('cmd', '_cart');
		$this->setData('upload', '1');

		$this->setData('no_note', 1);
		$locale = JFactory::getLanguage()->getTag();
		$locale = str_replace('-', '_', $locale);
		$this->setData('lc', $locale);
		$this->setData('currency_code', $params->get('ada_currency', 'USD'));
        $this->setData('charset', 'utf-8');
        $this->setData('tax', 0);



	}

	// public function onPaymentConfigurationSave(&$element) {

	// 	if(strpos($params->get('url'),'https://')===false){
	// 		$app = JFactory::getApplication();
	// 		$app->enqueueMessage('The URL must start with https://');
	// 		return false;
	// 	}
	// }

	/**
	 * Process Payment
	 *
	 * @param array $data        	
	 */
	public function processPayment($data)
	{

		

		// echo "<pre>";
		// print_r($data);
		// die;
		// $row = 123;
		// //EshopHelper::completeOrder($row);
		// // JPluginHelper::importPlugin('eshop');
		// // JFactory::getApplication()->triggerEvent('onAfterCompleteOrder', array($row));
		// print_r(JFactory::getApplication()->triggerEvent('onAfterStoreOrder', array($row)));
		// die;

		$siteUrl = EshopHelper::getSiteUrl();
		$countryInfo = EshopHelper::getCountry($data['payment_country_id']);
		$countProduct = 1;
		//Do the currency convert to USD if the selected currency does not supported by PayPal
		$rate = 1;
		$availableCurrenciesArr = array('AUD', 'CAD', 'EUR', 'GBP', 'JPY', 'USD', 'NZD', 'CHF', 'HKD', 'SGD', 'SEK', 'DKK', 'PLN', 'NOK', 'HUF', 'CZK', 'ILS', 'MXN', 'BRL', 'MYR', 'PHP', 'TWD', 'THB', 'TRY', 'RUB','ADA');
		
		if (!in_array($data['currency_code'], $availableCurrenciesArr))
		{
			$currency = new EshopCurrency();
			$rate = $currency->getExchangedValue('USD') / $currency->getExchangedValue($data['currency_code']);
			$data['currency_code'] = 'USD';
		}

		
		foreach ($data['products'] as $product)
		{
			$this->setData('item_name_' . $countProduct, $product['product_name']);
			$this->setData('item_number_' . $countProduct, $product['product_sku']);
		    $this->setData('amount_' . $countProduct, round($product['price'] * $rate, 2));
			$this->setData('quantity_' . $countProduct, $product['quantity']);
			$this->setData('weight_' . $countProduct, $product['weight']);

			$countProduct++;
		}
		
		if ($data['discount_amount_cart'])
		{
			$this->setData('discount_amount_cart', round($data['discount_amount_cart'] * $rate, 2));
		}
		
		if (JLanguageMultilang::isEnabled())
		{
			$db		= JFactory::getDbo();
			$query	= $db->getQuery(true);
			$tag	= JFactory::getLanguage()->getTag();
			$query->select('sef')
				->from('#__languages')
				->where('published = 1')
				->where('lang_code = ' . $db->quote($tag));
			$db->setQuery($query, 0, 1);
			$langLink = '&lang=' . $db->loadResult();
		}
		else 
		{
			$langLink = '';
		}

		$total_amount = $data['totals'][2]['value'] * 1098901.098901099;


		//$returl_url = $siteUrl . 'index.php?option=com_eshop&task=checkout.verifyPayment&payment_method=os_payco=' . $data['order_number'];
		$returl_url = $siteUrl . 'index.php?option=com_eshop&task=checkout.verifyPayment&payment_method=os_ada';
		
		//$api_key = $this->params->get('api_key');


		$request = [
            'amount' => (int)$total_amount,
            'paymentRequestExpirationTime' => (int)$this->expiration_time, 
            'receiptEmail' => $data['email'],
            'returnUrl'=>$returl_url,

        ];


          $curl = curl_init();
	      curl_setopt_array($curl, [
	      CURLOPT_URL => $this->url.'/'.'payment-request',
	      CURLOPT_RETURNTRANSFER => true,
	      CURLOPT_ENCODING => "",
	      CURLOPT_MAXREDIRS => 10,
	      CURLOPT_TIMEOUT => 30,
	      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	      CURLOPT_CUSTOMREQUEST => "PUT",
	      CURLOPT_POSTFIELDS => json_encode($request),
	      // CURLOPT_POSTFIELDS => "{\"parameters\":[{\"name\":\"name\",\"value\":\"$name\"},{\"name\":\"phone\",\"value\":\"$phone\"}],\"template_name\":\"$template_name\",\"broadcast_name\":\"$broadcast_name\"}",
	      CURLOPT_HTTPHEADER => [
	        "Authorization: Bearer ".$this->api_key,
	       "Content-Type: application/json"
	      ],
	    ]);

	    $response = curl_exec($curl);
	    $eshop_response = json_decode($response);
	    $session = JFactory::getSession();
        $session->set('uuid',$eshop_response->uuid);


	    	if (isset($eshop_response)) {
	        
	            if ($eshop_response->statusCode  == 400) {

	            	$this->html =  "<h3> An error occurred while placing order! Error info: <br><h5>" . $eshop_response->message[0].  "</h5></h3>";

	            	$mainframe = JFactory::getApplication ();
	                $mainframe->enqueueMessage ($this->html);

	                return $mainframe->redirect (JRoute::_ ('index.php?option=com_eshop&view=checkout',FALSE));


	            }else if ($eshop_response->statusCode  == 401) {

	            	$this->html =  "<h3> Please check your API KEY and UrL   <br><h5>" . $eshop_response->message.  "</h5></h3>";

	            	$mainframe = JFactory::getApplication ();
	                $mainframe->enqueueMessage ($this->html);

	                return $mainframe->redirect (JRoute::_ ('index.php?option=com_eshop&view=checkout',FALSE));

	            	
	            } else {
	                //https://adapay.finance
	                if ($this->sandbox == 1) {
		                header( 'Location: ' . 'https://sandbox.adapay.finance/pay/'.$eshop_response->uuid );
		                exit;
	                }else{
	                	header( 'Location: ' . 'https://adapay.finance/pay/'.$eshop_response->uuid );
		                exit;
	                }
	            }
            }else{


            	    $this->html =  "<h3>Please check your ADA PAY API KEY and Url from an administrator site</h3>";

	            	$mainframe = JFactory::getApplication ();
	                $mainframe->enqueueMessage ($this->html);

	                return $mainframe->redirect (JRoute::_ ('index.php?option=com_eshop&view=checkout',FALSE));

            }
		
		// $this->setData('currency_code', $data['currency_code']);
		// $this->setData('custom', $data['order_id']);
		// $this->setData('return', $siteUrl . 'index.php?option=com_eshop&view=checkout&layout=complete&order_number=' . $data['order_number']);
		// $this->setData('cancel_return', $siteUrl . 'index.php?option=com_eshop&view=checkout&layout=cancel&id=' . $data['order_id']);
		// $this->setData('notify_url', $siteUrl . 'index.php?option=com_eshop&task=checkout.verifyPayment&payment_method=os_ada' . $langLink);
		// $this->setData('address1', $data['payment_address_1']);
		// $this->setData('address2', $data['payment_address_2']);
		// $this->setData('city', $data['payment_city']);
		// $this->setData('country', $countryInfo->iso_code_2);
		// $this->setData('first_name', $data['payment_firstname']);
		// $this->setData('last_name', $data['payment_lastname']);
		// $this->setData('state', $data['payment_zone_name']);
		// $this->setData('zip', $data['payment_postcode']);
		// $this->setData('email', $data['email']);
		//$this->submitPost();
	}



	/**
	 * Process payment
	 */
	public function verifyPayment()
	{
		
		$ret = true; //$this->validate();
		$currency = new EshopCurrency();
		$session = JFactory::getSession();
		$uuid  = $session->get('uuid');
		$req = [

              'uuid' => $uuid,
              //'uuid'=>"851144a2-7d23-4a0a-9996-0e8378ff6e5e",

        ];

          $curl = curl_init();
	      curl_setopt_array($curl, [
	      CURLOPT_URL => $this->url.'/'.'payment-request/get-by-uuid',
	      CURLOPT_RETURNTRANSFER => true,
	      CURLOPT_ENCODING => "",
	      CURLOPT_MAXREDIRS => 10,
	      CURLOPT_TIMEOUT => 30,
	      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	      CURLOPT_CUSTOMREQUEST => "POST",
	      CURLOPT_POSTFIELDS => json_encode($req),
	      // CURLOPT_POSTFIELDS => "{\"parameters\":[{\"name\":\"name\",\"value\":\"$name\"},{\"name\":\"phone\",\"value\":\"$phone\"}],\"template_name\":\"$template_name\",\"broadcast_name\":\"$broadcast_name\"}",
	      CURLOPT_HTTPHEADER => [
	        "Authorization: Bearer".$api_key,
	       "Content-Type: application/json"
	      ],
	    ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);
        $data_convert = json_decode($response);

        // echo "<pre>";
        // print_r($data_convert);
        // die;

        $status = $subStatus = '';
        if (isset($data_convert->status) && $data_convert->status == 'confirmed' || isset($data_convert->status) && $data_convert->status== 'pending') {

        	$a = 0;
			$row = JTable::getInstance('Eshop', 'Order');
			$id = $a++;
			$row->load($id);
			// $amount = $this->postData['mc_gross'];
			if(isset($data_convert->status) && $data_convert->status  == 'confirmed'){
        	
        	
            	$row->order_status_id = EshopHelper::getConfigValue('complete_status_id');
           		$row->store();
           		EshopHelper::completeOrder($row);
            	JPluginHelper::importPlugin('eshop');
            	$dispatcher = JDispatcher::getInstance();
            	$dispatcher->trigger('onAfterCompleteOrder', array($row));
            }

			//Send confirmation email here
			if (EshopHelper::getConfigValue('order_alert_mail'))
			{
				EshopHelper::sendEmails($row);
			}
			
			JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_eshop&view=checkout&layout=complete'));
		
		}
		else
		{

			// $this->html =  "<h3> An error occurred while placing order! Error info:</h3>";

	        //$mainframe = JFactory::getApplication ();
	          //$mainframe->enqueueMessage ($this->html);

	         //return $mainframe->redirect (JRoute::_ ('index.php?option=com_eshop&view=checkout&layout=pending',FALSE));

			$session = JFactory::getSession();
            $session->set('omnipay_payment_error_reason', 'Your Payment not initiate yet please do the Payment');
            JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_eshop&view=checkout&layout=failure'));

		}
			
	}	



}


